function FTP(){

}

FTP.prototype.connect = function(server,user,password){
	this.sock=OpenAddress(server, 21)
	while(!this.sock.isConnected()){}
	while(this.sock.getPendingReadSize()==0) {}
	var response_header=ReadHeader(this.sock)
	response_header=response_header.join("\n")
	CommandReturnAnswer("USER "+user,this.sock)
	CommandReturnAnswer("PASS "+password,this.sock)
}

FTP.prototype.download = function(file,newFile){
	return FTPDownload(file,newFile,this.sock)
}

FTP.prototype.upload = function(file,newFile){
	FTPUpload(file,newFile,this.sock)
}

FTP.prototype.dele = function(fname){
	/*Socket lehren:*/ this.sock.read(this.sock.getPendingReadSize())
	var response_header = CommandReturnAnswer("DELE "+fname,this.sock)
	//while(this.sock.getPendingReadSize()==0){};this.sock.read(this.sock.getPendingReadSize())
	return response_header
}

FTP.prototype.dir setter = function(y){
	return CommandReturnAnswer("CWD "+y,this.sock)
}

FTP.prototype.dir getter = function(){
	var response_header = CommandReturnAnswer("PWD",this.sock)
	var pos=response_header.indexOf('"')
	var lpos=response_header.lastIndexOf('"',response_header.length)
	response_header=Left(response_header,pos+3)
	response_header=Right(response_header,lpos-pos)
	response_header=Left(response_header,response_header.length-1)
	return response_header
}

FTP.prototype.getFileList = function(fname){
	return FTPGetFileList(fname,this.sock)
}

FTP.prototype.getFileSize = function(fname){
	return FTPGetFileSize(fname,this.sock)
}

FTP.prototype.fileExist = function(fname){
	return FTPFileExist(fname,this.sock)
}

FTP.prototype.close = function(){
	CommandReturnAnswer("QUIT",this.sock)
	this.sock.close()
}


function FTPDownload(file,newFile,sock){
	if(FTPGetFileSize(file,sock)>0){
		/*Socket lehren:*/ sock.read(sock.getPendingReadSize())
		var temp=FTPEnterPasv(sock)
		var pasvIP=temp[0]
		var pasvPort=temp[1]
		var pasvSock=OpenAddress(pasvIP,pasvPort)
		while(!pasvSock.isConnected()) {}
		var request_header = "RETR "+file + "\r\n"
		sock.write(CreateByteArrayFromString(request_header))
		while(pasvSock.getPendingReadSize()==0) {}
		var response_header=pasvSock.read(pasvSock.getPendingReadSize())
		
		if(newFile!=undefined){
			var rfile=OpenRawFile(newFile,true)
			rfile.write(response_header)
			pasvSock.close()
			rfile.close()
		}else{
			pasvSock.close()
			return response_header
		}
	}else{
		if(newFile!=undefined){
			var rfile=OpenRawFile(newFile,true)
			rfile.close()
		}else{
			return CreateByteArray(0)
		}
	}
}

function FTPUpload(file,NewFile,sock){
	/*Socket lehren:*/ sock.read(sock.getPendingReadSize())
	if(typeof(file)=="string"){
		var rfile=OpenRawFile(file,false)
		var ba=rfile.read(rfile.getSize())
		rfile.close()
		if(newfile==undefined){newfile=file}
	}else{
		var ba=file
	}
	var temp=FTPEnterPasv(sock)
	var pasvIP=temp[0]
	var pasvPort=temp[1]
	var pasvSock=OpenAddress(pasvIP,pasvPort)
	CommandReturnAnswer("STOR "+NewFile,sock)
	pasvSock.write(ba)
	pasvSock.close()
	var t=GetTime();while(sock.getPendingReadSize()==0 && GetTime()-t<600){};sock.read(sock.getPendingReadSize())
}


function FTPEnterPasv(sock){
	Delay(100)
	/*Socket lehren:*/ sock.read(sock.getPendingReadSize())
	var response_header = CommandReturnAnswer("PASV",sock)
	
	response_header=Right(response_header,response_header.length-("227 Entering Passive Mode (").length)
	response_header=Left(response_header,response_header.length-2)
	var pasvIP=""
	var commas=0
	for(var t = 0;t<response_header.length&&commas<4;++t){
		if(response_header[t]==","[0]){++commas,pasvIP+="."}
		else pasvIP+=response_header[t]
	}
	pasvIP=Left(pasvIP,pasvIP.length-1)
	var pasvPort=0
	var port1=""
	var port2=""
	for(var t = pasvIP.length+1;t<response_header.length&&response_header[t]!=",";++t) port1+=response_header[t]
	for(var t = pasvIP.length+port1.length+2;t<response_header.length&&response_header[t]!=",";++t) port2+=response_header[t]
	port1=parseFloat(port1)
	port2=parseFloat(port2)
	var pasvPort=port1*256+port2
	if(pasvIP==""||pasvPort==NaN) return FTPEnterPasv(sock)
	return [pasvIP,pasvPort,response_header]
}

function FTPGetFileList(fname,sock){
	/*Socket lehren:*/ sock.read(sock.getPendingReadSize())
	if(fname==undefined) fname=""
	else fname=" "+fname
	var temp=FTPEnterPasv(sock)
	var pasvIP=temp[0]
	var pasvPort=temp[1]
	var pasvSock=OpenAddress(pasvIP,pasvPort)
	CommandReturnAnswer("LIST"+fname,sock)
	//var response_header=CommandReturnAnswer("LIST"+fname,sock)
	
	while(pasvSock.getPendingReadSize()==0){}
	var response_header=pasvSock.read(pasvSock.getPendingReadSize())
	response_header=CreateStringFromByteArray(response_header)
	var lines=[]
	var curline=""
	var x=0
	for(var t=0;t<response_header.length;++t){
		if(response_header[t]=="\n"){
			lines[x]=curline
			curline=""
			++x
		}else{
			curline+=response_header[t]
		}
	}
	var list=[]
	for(var t=0;t<x;t=t+1){
		var pos=lines[t].lastIndexOf(" ",lines[t].length)
		list[t]=Right(lines[t],lines[t].length-pos-1)
		list[t]=Left(list[t],list[t].length-1)
	}
	pasvSock.close()
	var t=GetTime();while(sock.getPendingReadSize()==0 && GetTime()-t<600){};sock.read(sock.getPendingReadSize())
	return list
}

function FTPFileExist(fname,sock){
	var list=FTPGetFileList("",sock)
	var t=list.length
	while(--t>-1) if(list[t]==fname) return true
	return false
}

function FTPGetFileSize(fname,sock){ //BETA, wahrscheinl.
	/*Socket lehren:*/ sock.read(sock.getPendingReadSize())
	if(fname==undefined) return "No filename given!"
	else fname=" "+fname
	var temp=FTPEnterPasv(sock)
	var pasvIP=temp[0]
	var pasvPort=temp[1]
	var t=GetTime();var pasvSock=OpenAddress(pasvIP,pasvPort)
	while(!pasvSock.isConnected()) {}
	CommandReturnAnswer("LIST"+fname,sock)
	var t=GetTime();while(pasvSock.getPendingReadSize()==0 && GetTime()-t<600){}
	var response_header=pasvSock.read(pasvSock.getPendingReadSize())
	response_header=CreateStringFromByteArray(response_header)
	if(1){
		var pos=response_header.lastIndexOf(" ",response_header.length)
		var pos=response_header.lastIndexOf(" ",pos-1)
		var pos=response_header.lastIndexOf(" ",pos-1)
		var pos=response_header.lastIndexOf(" ",pos-1)
		var pos=response_header.lastIndexOf(" ",pos-1)
		var lpos=pos
		var pos=response_header.lastIndexOf(" ",pos-1)
		
		
		var ret=Right(response_header,response_header.length-pos-1)
		ret=Left(ret,lpos-pos)
	}
	//ret=parseFloat(ret)
	pasvSock.close()
	var t=GetTime();while(sock.getPendingReadSize()==0 && GetTime()-t<600){};sock.read(sock.getPendingReadSize())
	return ret
}

function FTPGetFileType(fname,sock){
	/*Socket lehren:*/ sock.read(sock.getPendingReadSize())
	if(fname==undefined) return "No filename given!"
	var temp=FTPEnterPasv(sock)
	var pasvIP=temp[0]
	var pasvPort=temp[1]
	var pasvSock=OpenAddress(pasvIP,pasvPort)
	CommandReturnAnswer("LIST",sock)
	while(pasvSock.getPendingReadSize()==0){}
	response_header=pasvSock.read(pasvSock.getPendingReadSize())
	response_header=CreateStringFromByteArray(response_header)
	var lines=[]
	var curline=""
	var x=0
	for(var t=0;t<response_header.length;++t){
		if(response_header[t]=="\n"){
			lines[x]=curline
			curline=""
			++x
		}else{
			curline+=response_header[t]
		}
	}
	
	
	var t=GetTime();while(sock.getPendingReadSize()==0 && GetTime()-t<600){};sock.read(sock.getPendingReadSize())
	var list=FTPGetFileList("",sock)
	var fpos=undefined
	for(var t=0;t<list.length;++t) if(list[t]==fname) fpos=t
	if(fpos==undefined) return "File doesn't Exist!"
	if(1){
		var pos=lines[fpos].lastIndexOf("ftp",lines[fpos].length)
		var pos=lines[fpos].lastIndexOf("ftp",pos-1)
		var pos=lines[fpos].lastIndexOf(" ",pos-1)
		var lpos=pos
		var pos=lines[fpos].lastIndexOf(" ",pos-1)
	
		
		var ret=Right(lines[fpos],lines[fpos].length-pos-1)
		var ret=Left(ret,lpos-pos)
	}
	var ret=parseFloat(ret)
	pasvSock.close()
	return ret
}



function CommandShowAnswer(cmd,sock){
	var request_header = cmd + "\r\n"
	sock.write(CreateByteArrayFromString(request_header))
	var t=GetTime();while(sock.getPendingReadSize()==0 && GetTime()-t<600){}
	var response_header=ReadHeader(sock)
	response_header=response_header.join("\n")
	Show(response_header)
	return response_header
}

function CommandReturnAnswer(cmd,sock){
	var request_header = cmd + "\r\n"
	sock.write(CreateByteArrayFromString(request_header))
	var t=GetTime();while(sock.getPendingReadSize()==0 && GetTime()-t<600){}
	var response_header=ReadHeader(sock)
	response_header=response_header.join("\n")
	return response_header
}

function ReadHeader(socket) {
  var response_header = [];

  do {
    var line = "";

    var lh = 0;
    var ch = 0;
    var ba = null;
    var done = false;
    
    do {   
      ba = socket.read(1);
   
      if (ba != null) {
        ch = CreateStringFromByteArray(ba);
        
        if (ch != '\r' && ch != '\n') {
          line += ch;
        } else {
          if (ch == '\n') {
            if (line.length > 0) {
              response_header.push ( line );
            } else {
              done = true;
            }

            line = "";
          }
        }
      
        lh = ch;
      }
    } while ( ba != null && !done );
    
  } while ( line != null && line.length > 0);  

  return response_header;
}


function Show(text){
	while(!AreKeysLeft()){
		GetSystemFont().drawTextBox(0,0,GetScreenWidth(),GetScreenHeight(),0,text)
		FlipScreen()
	}
	GetKey()
}

function ReadDataToRawFile(socket, rawfile, content_length)
{
  var content_read = 0;
  var ba = socket.read(content_length - content_read);
  
  while (content_read < content_length && !IsKeyPressed(KEY_ESCAPE)) {
    if (/*1*/0) {
      GetSystemFont().drawText(16, 16, "Reading data... " + Math.round((content_read / content_length) * 100) + "%");
      FlipScreen();
    }

    if (ba != null) {
      if (rawfile != null) {
        rawfile.write(ba);
      }
        
      content_read += ba.length;
    }
      
    if (content_read < content_length) {
      ba = socket.read(content_length - content_read);
    }
  }
  
  return content_read;
}

function URLtoSite(URL){
	var site=URL
	site=site.replace("http://www.","")
	var pos=site.indexOf("/")
	site=Left(site,pos)
	return site
}

function URLtoFilename(URL){
	var pos=URLtoSite(URL).length
	return Right(URL,URL.length-pos-11)
}


function Left(s,a){
	var ba=CreateByteArrayFromString(s)
	var ret=""
	for(var t=0;t<a&&t<ba.length;++t){
		ret+=CreateStringFromCode(ba[t])
	}
	return ret
}

function Right(s,a){
	var ba=CreateByteArrayFromString(s)
	var ret=""
	for(var t=1;t<=a;++t){
		ret=CreateStringFromCode(ba[ba.length-t])+ret
	}
	return ret
}

function StringSearchChar(str,serc,first){
	if(first==undefined) first=0
	str=CreateByteArrayFromString(str)
	serc=CreateByteArrayFromString(serc)
	for(var t=first;t<str.length;++t) if(str[t]==serc[0]) return t
	return -1
}
